﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SolderFeederStationSettings.ascx.vb" Inherits="Web.SolderFeederStationSettings" %>
<%@ Register Src="~/private/stations/base/Sections/ControlMode.ascx" TagName="cu_controlmode" TagPrefix="uc" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>

<asp:UpdatePanel runat="server" ID="UpdatePanelParametros" UpdateMode="Conditional">
    <ContentTemplate>

        <div class="mode-panel">
            <div class="holder">
                <asp:LinkButton ID="LnkGuardar" CssClass="guardar" runat="server" Text="guardar" CommandName="guardar"></asp:LinkButton>
                <uc:cu_controlmode ID="cu_controlmode" runat="server" Visible="false" />
            </div>
            <div class="btn-holder">
                <asp:LinkButton ID="btn_GeneralSetting" runat="server" CssClass="btn btntab active" CommandName="General" OnClick="btn_Param_Click"><%= CurrentContext.Translator.Translate("PARAM_MAIN_SETTING")%></asp:LinkButton>
                <asp:LinkButton ID="btn_Ethernet" runat="server" CssClass="btn btntab" CommandName="Ethernet" OnClick="btn_Param_Click"><%= CurrentContext.Translator.Translate("PARAM_ETHERNET")%></asp:LinkButton>
                <asp:LinkButton ID="btn_Robot" runat="server" CssClass="btn btntab" CommandName="Robot" OnClick="btn_Param_Click"><%= CurrentContext.Translator.Translate("PARAM_ROBOT")%></asp:LinkButton>
                <asp:LinkButton ID="btn_Profiles" runat="server" CssClass="btn btntab" CommandName="Profiles" OnClick="btn_Param_Click"><%= CurrentContext.Translator.Translate("PARAM_PROFILES")%></asp:LinkButton>
            </div>
        </div>

        <div class="parameters-block">
            <div id="divGeneralSettings" runat="server">
                <ul class="parameters-list jcf-scrollable" data-area="edit-area" runat="server" id="DivCamps">
                    <li runat="server" id="li_Nombre">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_NAME")%></span>
                            <asp:LinkButton ID="LblValorStationName" CssClass="value" runat="server" Style="min-height: 20px;" CommandName="StationName#string" CommandArgument="stnName" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li runat="server" id="li_TempMax">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_MAXAIRTEMP")%></span>
                            <asp:LinkButton ID="LblValorMaxTemp" CssClass="value" runat="server" CommandName="MaxTemp#temperatura" CommandArgument="Maximum air temp" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li runat="server" id="li_TempMin">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_MINAIRTEMP")%></span>
                            <asp:LinkButton ID="LblValorMinTemp" CssClass="value" runat="server" CommandName="MinTemp#temperatura" CommandArgument="Minimum air temp" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li runat="server" id="li_ExtTCMaxTemp">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_MAXEXTTEMP")%></span>
                            <asp:LinkButton ID="LblValorExtTCMaxTemp" CssClass="value" runat="server" CommandName="ExtTCMaxTemp#temperatura" CommandArgument="Maximum ext temp" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li runat="server" id="li_ExtTCMinTemp">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_MINEXTTEMP")%></span>
                            <asp:LinkButton ID="LblValorExtTCMinTemp" CssClass="value" runat="server" CommandName="ExtTCMinTemp#temperatura" CommandArgument="Minimum ext temp" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li runat="server" id="li_MaxFlow">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_MAXFLOW")%></span>
                            <asp:LinkButton ID="LblValorMaxFlow" CssClass="value" runat="server" CommandName="MaxFlow#integer" CommandArgument="Maximum flow" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li runat="server" id="li_MinFlow">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_MINFLOW")%></span>
                            <asp:LinkButton ID="LblValorMinFlow" CssClass="value" runat="server" CommandName="MinFlow#integer" CommandArgument="Minimum flow" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li runat="server" id="li_Beep">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_BEEP")%></span>
                            <asp:LinkButton ID="LblValorBeep" CssClass="value" runat="server" CommandName="Beep#boolean" CommandArgument="Beep" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li runat="server" id="li_CodigoPIN">
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_PIN")%></span>
                            <asp:LinkButton ID="LblValorCodigoPIN" CssClass="value" runat="server" CommandName="CodigoPIN#integer" CommandArgument="PIN Code" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                </ul>
            </div>
            <div id="divEthernet" runat="server" visible="false">
                <ul class="parameters-list jcf-scrollable" data-area="edit-area" runat="server" id="DivCampsEthernet">
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ETHERNET_AUTO_IP")%></span>
                            <asp:LinkButton ID="LblValorAutoIP" CssClass="value" runat="server" CommandName="stnAutoIP" OnClick="ListaParametroEvento_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ETHERNET_IP")%></span>
                            <asp:LinkButton ID="LblValorIP" CssClass="value" runat="server" CommandName="IP#Mask#PARAM_ETHERNET_IP" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ETHERNET_SUBNETMASK")%></span>
                            <asp:LinkButton ID="LblValorSubNetMask" CssClass="value" runat="server" CommandName="SubNetMask#Mask#PARAM_ETHERNET_SUBNETMASK" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ETHERNET_GATEWAY")%></span>
                            <asp:LinkButton ID="LblValorGateway" CssClass="value" runat="server" CommandName="Gateway#Mask#PARAM_ETHERNET_GATEWAY" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ETHERNET_DNS")%></span>
                            <asp:LinkButton ID="LblValorDNS" CssClass="value" runat="server" CommandName="DNS#Mask#PARAM_ETHERNET_DNS" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ETHERNET_PORT")%></span>
                            <asp:LinkButton ID="LblValorPORT" CssClass="value" runat="server" CommandName="PORT#integer#PARAM_ETHERNET_PORT" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                </ul>

            </div>
            <div id="divRobot" runat="server" visible="false">
                <ul class="parameters-list jcf-scrollable" data-area="edit-area" runat="server" id="divCampsRobot">
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ROBOT_STATUS")%></span>
                            <asp:LinkButton ID="LblValorRobotStatus" CssClass="value" runat="server" CommandName="RobotStatus" CommandArgument="Status" OnClick="ListaParametroEvento_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= If(CurrentStation.Instance.IsExcellenceStation, CurrentContext.Translator.Translate("PARAM_ROBOT_ADDRESS"), CurrentContext.Translator.Translate("PARAM_ROBOT_PROTOCOL"))%></span>
                            <asp:LinkButton ID="LblValorRobotProtocol" CssClass="value" runat="server" CommandName="RobotProtocol#Lista#PARAM_ROBOT_PROTOCOL" OnClick="EditParameter_Click"></asp:LinkButton>
                            <asp:LinkButton ID="LblValorRobotAddressExcellence" CssClass="value" runat="server" CommandName="RobotAddressExcellence#Lista#PARAM_ROBOT_ADDRESS" Visible="False" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= If(CurrentStation.Instance.IsExcellenceStation, CurrentContext.Translator.Translate("PARAM_ROBOT_ADDRESS_NUMBER"), CurrentContext.Translator.Translate("PARAM_ROBOT_ADDRESS"))%></span>
                            <asp:LinkButton ID="LblValorRobotAddress" CssClass="value" runat="server" CommandName="RobotAddress#integer#PARAM_ROBOT_ADDRESS" CommandArgument="RobotAddress" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ROBOT_SPEED")%></span>
                            <asp:LinkButton ID="LblValorRobotSpeed" CssClass="value" runat="server" CommandName="RobotSpeed#Lista#PARAM_ROBOT_SPEED" CommandArgument="RobotSpeed" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ROBOT_DATA_BITS")%></span>
                            <asp:LinkButton ID="LblValorDataBits" CssClass="value" Style="border-bottom: none !important; cursor: default !important;" runat="server" CommandArgument="RobotDataBits"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ROBOT_STOP_BITS")%></span>
                            <asp:LinkButton ID="LblValorRobotStopBits" CssClass="value" runat="server" CommandName="RobotStopBits#Lista#PARAM_ROBOT_STOP_BITS" CommandArgument="RobotStopBits" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                    <li>
                        <div class="container">
                            <span class="parameter-name"><%= CurrentContext.Translator.Translate("PARAM_ROBOT_PARITY")%></span>
                            <asp:LinkButton ID="LblValorRobotParity" CssClass="value" runat="server" CommandName="RobotParity#Lista#PARAM_ROBOT_PARITY" CommandArgument="RobotParity" OnClick="EditParameter_Click"></asp:LinkButton>
                        </div>
                    </li>
                </ul>
            </div>
        </div>

        <!--Panel de de formulario de entrada de datos -->
        <asp:Panel ID="PanelEntradaDatos" runat="server" Style="display: none" CssClass="error-message" DefaultButton="btnAceptar_PanelEntradaDatos">
            <div class="holder">
                <asp:Literal ID="info_PanelEntradaDatos" runat="server"></asp:Literal>
                <asp:TextBox ID="value_PanelEntradaDatos" runat="server" Width="280" MaxLength="100" Style="margin: 0 auto; display: block !important;"></asp:TextBox>
                <asp:RegularExpressionValidator ID="RegExp1" runat="server" Font-Bold="true" ControlToValidate="value_PanelEntradaDatos" ForeColor="#ff6666" ValidationGroup="CONTROLENTRADA" ValidationExpression="^[0-9]{4,4}$" />
                <asp:DropDownList runat="server" ID="ucListaParam" CssClass="combo" Width="150" Style="margin: 0 auto; display: block !important;"></asp:DropDownList>
                <span style="margin: 0 auto; display: block !important;">
                    <telerik:RadMaskedTextBox RenderMode="Lightweight" ID="IdMask" runat="server" SelectionOnFocus="SelectAll" PromptChar="" Width="170px" Mask="<0..255>.<0..255>.<0..255>.<0..255>"></telerik:RadMaskedTextBox>
                </span>
                <ajaxToolkit:FilteredTextBoxExtender ID="regnumint" runat="server" TargetControlID="value_PanelEntradaDatos" ValidChars="1234567890." />
                <asp:RangeValidator ID="regValidator" ControlToValidate="value_panelEntradaDatos" MinimumValue="1" ForeColor="#ff6666" Font-Bold="true" MaximumValue="50" Type="Integer" Text="" runat="server" ValidationGroup="CONTROLENTRADA"></asp:RangeValidator>
                <br />
                <asp:LinkButton ID="btnAceptar_PanelEntradaDatos" runat="server" CssClass="btn" OnClick="btnAceptar_PanelEntradaDatos_Click" ValidationGroup="CONTROLENTRADA"><%= CurrentContext.Translator.Translate("ADMIN_BTN_DELETE_OK")%></asp:LinkButton>
                <asp:LinkButton ID="btnCancelar_PanelEntradaDatos" runat="server" CssClass="btn"><%= CurrentContext.Translator.Translate("ADMIN_BTN_CANCEL")%></asp:LinkButton>
            </div>
        </asp:Panel>

        <!-- controles ajax-->
        <ajaxToolkit:ModalPopupExtender ID="MPE_PanelEntradaDatos" runat="server" TargetControlID="hdnPanelEntradaDatos" PopupControlID="PanelEntradaDatos" BackgroundCssClass="" DropShadow="false" PopupDragHandleControlID="" X="0" />

        <!-- controles ocultos-->
        <asp:HiddenField ID="hdnPanelEntradaDatos" runat="server" />
        <asp:HiddenField ID="hdnBtnActive" runat="server" />

        <!--Panel de de formulario  verificación modo robot -->
        <asp:Panel ID="PanelModeRobot" runat="server" Style="display: none" CssClass="error-message">
            <div class="holder">
                <asp:Literal ID="info_ModeRobot" runat="server"></asp:Literal>
                <br />
                <br />
                <asp:LinkButton ID="btnAceptar_PanelModeRobot" runat="server" CssClass="btn" OnClick="btnAceptar_PanelModeRobot_Click"><%= CurrentContext.Translator.Translate("ADMIN_BTN_DELETE_OK")%></asp:LinkButton>
                <asp:LinkButton ID="btnCancelar_PanelModerobot" runat="server" CssClass="btn"><%= CurrentContext.Translator.Translate("ADMIN_BTN_CANCEL")%></asp:LinkButton>
            </div>
        </asp:Panel>

        <!-- controles ajax-->
        <ajaxToolkit:ModalPopupExtender ID="MPE_PanelModeRobot" runat="server" TargetControlID="hdnPanelModeRobot" PopupControlID="PanelModeRobot" BackgroundCssClass="" DropShadow="false" PopupDragHandleControlID="" X="0" />

        <!-- controles ocultos-->
        <asp:HiddenField ID="hdnPanelModeRobot" runat="server" />
        <asp:HiddenField ID="hdnlmodo" runat="server" />

    </ContentTemplate>
</asp:UpdatePanel>

<asp:UpdateProgress ID="UpdateProgressParametros" runat="server" AssociatedUpdatePanelID="UpdatePanelParametros" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" Style="z-index: 100002;" />
    </ProgressTemplate>
</asp:UpdateProgress>

<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderParametros" TargetControlID="UpdatePanelParametros" BehaviorID="animation" runat="server">
    <Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="LockScreen();" />
        </Sequence>
    </OnUpdating>        
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen(); initRefreshFunctions2($('div.ajax-holder'));" />
        </Sequence>
    </OnUpdated>
    </Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>


